DROP PROCEDURE [hips].[PatientMasterNameDelete]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 18 October 2012
-- Description:   Deletes an existing record from the Patient Master Names Table
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterNameDelete] 
(
	  @PatientMasterNameId INT
)
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode int,
			@intRowsAffected int

    SELECT  @intErrorCode = 0,
			@intRowsAffected = 0

    DELETE
     FROM [hips].[PatientMasterName]
     WHERE [PatientMasterNameId] = @PatientMasterNameId

    SELECT @intErrorCode = @@ERROR,
   		   @intRowsAffected = @@ROWCOUNT

	SELECT @intRowsAffected AS RowsAffected

    RETURN(@intErrorCode)
END
GO

